/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.scouter.netherdepthsupgrade.NetherDepthsUpgrade;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class PlaceWetLavaSpongeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = NetherDepthsUpgrade.prefix("placed_block");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        Block block = PlaceWetLavaSpongeTrigger.deserializeBlock(pJson);
        StatePropertiesPredicate statepropertiespredicate = StatePropertiesPredicate.m_67679_((JsonElement)pJson.get("state"));
        if (block != null) {
            statepropertiespredicate.m_67672_(block.m_49965_(), p_59475_ -> {
                throw new JsonSyntaxException("Block " + block + " has no property " + p_59475_ + ":");
            });
        }
        LocationPredicate locationpredicate = LocationPredicate.m_52629_((JsonElement)pJson.get("location"));
        ItemPredicate itempredicate = ItemPredicate.m_45051_((JsonElement)pJson.get("item"));
        return new TriggerInstance(pEntityPredicate, block, statepropertiespredicate, locationpredicate, itempredicate);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject pObject) {
        if (pObject.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)pObject, (String)"block"));
            return (Block)Registry.f_122824_.m_6612_(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + resourcelocation + "'"));
        }
        return null;
    }

    public void trigger(ServerPlayer pPlayer, BlockPos pPos, ItemStack pItem) {
        BlockState blockstate = pPlayer.m_9236_().m_8055_(pPos);
        this.m_66234_(pPlayer, p_59481_ -> p_59481_.matches(blockstate, pPos, pPlayer.m_9236_(), pItem));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final Block block;
        private final StatePropertiesPredicate state;
        private final LocationPredicate location;
        private final ItemPredicate item;

        public TriggerInstance(EntityPredicate.Composite pPlayer, @Nullable Block pBlock, StatePropertiesPredicate pState, LocationPredicate pLocation, ItemPredicate pItem) {
            super(ID, pPlayer);
            this.block = pBlock;
            this.state = pState;
            this.location = pLocation;
            this.item = pItem;
        }

        public static TriggerInstance placedBlock(Block pBlock) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, pBlock, StatePropertiesPredicate.f_67658_, LocationPredicate.f_52592_, ItemPredicate.f_45028_);
        }

        public boolean matches(BlockState pState, BlockPos pPos, ServerLevel pLevel, ItemStack pItem) {
            if (this.block != null && !pState.m_60713_(this.block)) {
                return false;
            }
            if (!this.state.m_67667_(pState)) {
                return false;
            }
            if (!this.location.m_52617_(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_())) {
                return false;
            }
            return this.item.m_45049_(pItem);
        }

        public JsonObject m_7683_(SerializationContext pConditions) {
            JsonObject jsonobject = super.m_7683_(pConditions);
            if (this.block != null) {
                jsonobject.addProperty("block", Registry.f_122824_.m_7981_((Object)this.block).toString());
            }
            jsonobject.add("state", this.state.m_67666_());
            jsonobject.add("location", this.location.m_52616_());
            jsonobject.add("item", this.item.m_45048_());
            return jsonobject;
        }
    }
}

